#!/bin/bash

MYHOME=/home/pi/liquid/zac

DATE=`/bin/date "+%d.%m.%Y %H:%M:%S"`

#Skalierung der Y-Achse auf ein festes Maß

RANGE="-l-1 -u3 -r "
#RANGE="-l2900 -u3600 -r "
#RANGE2="-l-2000 -u36000 -r "
RANGE2="-l-2 -u36 -r "
#RANGE3="-l0 -u360 -r "
RANGE3="-l-30 -u360 -r "
#SRANGE="-l-20 -u40 -r "
#RULCOL="00FFFF"
RULCOL="6622FF"

# HRULE:0#$RULCOL \
# LINE:0#$RULCOL:"...":dashes=15,5,5,10 \
# HRULE:0#$RULCOL:dashes=2,4 \
# LINE:0#$RULCOL:"":dashes=4,4 \


array=( 1 2 3 4 5 6 )
# Alle Elemente im Array durchlaufen
for value in ${array[*]}
do
   #echo $value

   case "$value" in
     1)	W=800
	H=400	 
	START=14400
	TITEL="4 Stunden"
	MODUS="LAST"
	INTERVALL="4h" ;;
     2)	W=800
	H=200	 
	START=129600
	TITEL=" 36 Stunden"
	MODUS="AVERAGE"
	INTERVALL="36h" ;;
     3)	W=800
	H=200	 
	START=604800
	TITEL="7 Tage"
	MODUS="AVERAGE"
	INTERVALL="7t" ;;
     4)	W=600
	H=100	 
	START=2592000
	TITEL="4 Wochen"
	MODUS="AVERAGE"
	INTERVALL="4w" ;;
     5)	W=600
	H=100	 
	START=31536000
	TITEL="12 Monate"
	MODUS="AVERAGE"
	INTERVALL="12m" ;;
     6)	W=600
	H=100	 
	START=580608000
	TITEL="20 Jahre"
	MODUS="AVERAGE"
	INTERVALL="20j" ;;
   esac
   #echo "$W $H $START $INTERVALL"


# Erzeuge Balancer Diagramme
nice -n 19 /usr/bin/rrdtool graph $MYHOME/rrdtool/zac$INTERVALL\_graph.png \
--start -$START -a PNG $RANGE -t "$TITEL           Stand: $DATE" --vertical-label "[V], [A], [W]" -w $W -h $H \
-c BACK#000000 -c CANVAS#000000 -c FONT#FFFFFF -c GRID#00FFFF -c MGRID#00FFFF -c FRAME#00FFFF \
-c SHADEA#000000 -c SHADEB#000000 -c AXIS#FFFFFF -c ARROW#FFFFFF \
DEF:myzac3=$MYHOME/rrdtool/zac.rrd:zac3:AVERAGE \
DEF:myzac4=$MYHOME/rrdtool/zac.rrd:zac4:AVERAGE \
DEF:myzac5=$MYHOME/rrdtool/zac.rrd:zac5:AVERAGE \
DEF:myzac7=$MYHOME/rrdtool/zac.rrd:zac7:AVERAGE \
LINE:0#$RULCOL \
LINE:3#$RULCOL \
LINE1:myzac3#58d3f7:"Spannung" VDEF:zac3a=myzac3,AVERAGE GPRINT:zac3a:"%5.2lf" \
LINE1:myzac4#ffff00:"Strom" VDEF:zac4a=myzac4,AVERAGE GPRINT:zac4a:"%5.2lf" \
LINE1:myzac5#00ff00:"Leistung" VDEF:zac5a=myzac5,AVERAGE GPRINT:zac5a:"%5.2lf\n" \
LINE1:myzac7#00ffff:"Kapazität" VDEF:zac7a=myzac7,AVERAGE GPRINT:zac7a:"%5.0lf\n" \
 > /dev/null

done

